@extends('layouts.admin')

@section('content')
    <!-- Page Header -->
    <div class="py-6 bg-[#F6F6F6] border-b border-[#CBB4B0]">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold text-gray-900">Detail Hasil Pemeriksaan</h1>
                    <p class="text-gray-600 mt-1">Informasi lengkap hasil pemeriksaan</p>
                </div>
                <div class="flex items-center space-x-4">
                    <a href="{{ route('admin.exam-results.index') }}" 
                       class="bg-[#8B8B8B] text-white px-4 py-2 rounded-none hover:bg-[#192D50] transition duration-150">
                        Kembali
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="py-8 bg-[#F6F6F6]">
        <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Exam Result Info -->
            <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none mb-8 border border-[#CBB4B0]">
                <div class="p-6">
                    <div class="flex items-center justify-between mb-6">
                        <h3 class="text-lg font-medium text-gray-900">Informasi Hasil Pemeriksaan</h3>
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium
                            @if($examResult->status == 'completed') bg-[#8B8B8B] text-white
                            @elseif($examResult->status == 'pending') bg-[#192D50] text-white
                            @else bg-[#192D50] text-white @endif">
                            {{ ucfirst($examResult->status) }}
                        </span>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <p class="text-sm text-gray-600">ID Hasil Pemeriksaan:</p>
                            <p class="font-medium text-gray-900">#{{ $examResult->id }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Jenis Pemeriksaan:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->exam_type }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Tanggal Pemeriksaan:</p>
                            <p class="font-medium text-gray-900">{{ \Carbon\Carbon::parse($examResult->exam_date)->format('d F Y') }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Tanggal Dibuat:</p>
                            <p class="font-medium text-gray-900">{{ \Carbon\Carbon::parse($examResult->created_at)->format('d F Y H:i') }}</p>
                        </div>
                    </div>
                    
                    @if($examResult->notes)
                    <div class="mt-6">
                        <p class="text-sm text-gray-600">Catatan:</p>
                        <p class="font-medium text-gray-900 mt-1">{{ $examResult->notes }}</p>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Patient Information -->
            @if($examResult->patient)
            <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none mb-8 border border-[#CBB4B0]">
                <div class="p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Informasi Pasien</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <p class="text-sm text-gray-600">Nama:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->patient->name }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Email:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->patient->email }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Telepon:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->patient->phone }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">MRN:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->patient->mrn ?? 'Belum ada' }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Tanggal Lahir:</p>
                            <p class="font-medium text-gray-900">{{ \Carbon\Carbon::parse($examResult->patient->birth_date)->format('d F Y') }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Jenis Kelamin:</p>
                            <p class="font-medium text-gray-900">{{ ucfirst($examResult->patient->gender) }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Password Kredensial:</p>
                            <div class="flex items-center space-x-2">
                                <p class="font-medium text-gray-900" id="patient-password">{{ $examResult->patient?->password_plain ?? 'Belum ada' }}</p>
                                @if($examResult->patient?->password_plain)
                                <button type="button" onclick="togglePassword()" 
                                        class="text-[#8B8B8B] hover:text-[#CBB4B0] text-sm font-medium">
                                    <span id="toggle-text">Sembunyikan</span>
                                </button>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @else
            <!-- No Patient Information -->
            <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none mb-8 border border-[#CBB4B0]">
                <div class="p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Informasi Pasien</h3>
                    <div class="text-center py-8">
                        <div class="text-gray-500 mb-4">
                            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                            </svg>
                        </div>
                        <p class="text-gray-600 text-lg font-medium">Tidak ada informasi pasien</p>
                        <p class="text-gray-500 mt-2">Hasil pemeriksaan ini tidak terkait dengan pasien tertentu</p>
                    </div>
                </div>
            </div>
            @endif

            <!-- Employee Information -->
            @if($examResult->employee)
            <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none mb-8 border border-[#CBB4B0]">
                <div class="p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Informasi Karyawan</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <p class="text-sm text-gray-600">Nama:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->employee->name }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Email:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->employee->email }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Telepon:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->employee->phone }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Nomor Karyawan:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->employee->employee_number }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Perusahaan:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->employee->company->name ?? 'N/A' }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Posisi:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->employee->position }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Departemen:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->employee->department }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Tanggal Lahir:</p>
                            <p class="font-medium text-gray-900">{{ \Carbon\Carbon::parse($examResult->employee->birth_date)->format('d F Y') }}</p>
                        </div>
                    </div>
                </div>
            </div>
            @endif

            <!-- Partner Information -->
            @if($examResult->partner)
            <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none mb-8 border border-[#CBB4B0]">
                <div class="p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Informasi Rekanan</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <p class="text-sm text-gray-600">Nama:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->partner->name }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Kode:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->partner->code }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Email:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->partner->email }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Telepon:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->partner->phone }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Contact Person:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->partner->contact_person }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Alamat:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->partner->address }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Status:</p>
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                @if($examResult->partner->status == 'active') bg-[#8B8B8B] text-white
                                @else bg-[#192D50] text-white @endif">
                                {{ ucfirst($examResult->partner->status) }}
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            @endif

            <!-- Registration Information -->
            @if($examResult->registration)
            <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none mb-8 border border-[#CBB4B0]">
                <div class="p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Informasi Pendaftaran</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <p class="text-sm text-gray-600">ID Pendaftaran:</p>
                            <p class="font-medium text-gray-900">#{{ $examResult->registration->id }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Tanggal Pendaftaran:</p>
                            <p class="font-medium text-gray-900">{{ \Carbon\Carbon::parse($examResult->registration->created_at)->format('d F Y H:i') }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Status Pembayaran:</p>
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                @if($examResult->registration->paid) bg-[#8B8B8B] text-white
                                @else bg-[#192D50] text-white @endif">
                                {{ $examResult->registration->paid ? 'Lunas' : 'Belum Lunas' }}
                            </span>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Total Biaya:</p>
                            <p class="font-medium text-gray-900">Rp {{ number_format($examResult->registration->total_amount, 0, ',', '.') }}</p>
                        </div>
                    </div>
                </div>
            </div>
            @endif

            <!-- Partner Information -->
            @if($examResult->partner)
            <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none mb-8 border border-[#CBB4B0]">
                <div class="p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Informasi Rekanan</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <p class="text-sm text-gray-600">Nama Rekanan:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->partner->name }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Email:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->partner->email }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Telepon:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->partner->phone }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Alamat:</p>
                            <p class="font-medium text-gray-900">{{ $examResult->partner->address }}</p>
                        </div>
                    </div>
                </div>
            </div>
            @endif

            <!-- Result File -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-none">
                <div class="p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">File Hasil Pemeriksaan</h3>
                    
                    @if($examResult->result_file_path)
                    <div class="border border-gray-200 rounded-none p-4">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center">
                                <svg class="w-8 h-8 text-[#CBB4B0] mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                </svg>
                                <div>
                                    <p class="font-medium text-gray-900">{{ basename($examResult->result_file_path) }}</p>
                                    <p class="text-sm text-gray-500">File hasil pemeriksaan</p>
                                </div>
                            </div>
                            <div class="flex items-center space-x-2">
                                <a href="{{ asset('storage/' . $examResult->result_file_path) }}" 
                                   target="_blank"
                                   class="inline-flex items-center px-3 py-2 border border-transparent text-sm font-medium rounded-none text-[#CBB4B0] bg-[#F6F6F6] hover:bg-[#192D50] hover:text-white transition duration-150">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                    </svg>
                                    Lihat File
                                </a>
                                <a href="{{ asset('storage/' . $examResult->result_file_path) }}" 
                                   download
                                   class="inline-flex items-center px-3 py-2 border border-transparent text-sm font-medium rounded-none text-white bg-[#192D50] hover:bg-[#8B8B8B] transition duration-150">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                    </svg>
                                    Download
                                </a>
                            </div>
                        </div>
                    </div>
                    @else
                    <div class="text-center py-8">
                        <svg class="w-12 h-12 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        <p class="text-gray-500">Tidak ada file hasil pemeriksaan</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

<script>
function togglePassword() {
    const passwordDisplay = document.getElementById('patient-password');
    const toggleText = document.getElementById('toggle-text');
    const passwordPlain = '{{ $examResult->patient?->password_plain ?? "" }}';
    
    if (passwordDisplay.textContent === '••••••••') {
        passwordDisplay.textContent = passwordPlain;
        toggleText.textContent = 'Sembunyikan';
    } else {
        passwordDisplay.textContent = '••••••••';
        toggleText.textContent = 'Tampilkan';
    }
}

// Initialize password display
document.addEventListener('DOMContentLoaded', function() {
    const passwordDisplay = document.getElementById('patient-password');
    const passwordPlain = '{{ $examResult->patient?->password_plain ?? "" }}';
    
    if (passwordPlain && passwordPlain !== '' && passwordPlain !== 'Belum ada') {
        // Show password as dots initially
        passwordDisplay.textContent = '••••••••';
    }
});
</script>
